import logging
import pickle
from flask import Flask, request, render_template, redirect, url_for

def save_obj(obj, name):
    with open('obj/'+ name + '.pkl', 'wb') as f:
        pickle.dump(obj, f, pickle.HIGHEST_PROTOCOL)

def load_obj(name):
    with open('obj/' + name + '.pkl', 'rb') as f:
        return pickle.load(f)

app = Flask(__name__)

ANSWERED_GOOD = {}
try:
  ANSWERED_GOOD = load_obj('ANSWERED_GOOD')
except:
  print ('WARNING: no obj/ANSWERED_GOOD.pkl file found')

def good_answer(task, nickname):
  if nickname not in ANSWERED_GOOD:
    ANSWERED_GOOD[nickname] = set()
  ANSWERED_GOOD[nickname].add(task)
  save_obj(ANSWERED_GOOD, 'ANSWERED_GOOD')


# WATCHOUT: this works because we have only 13 question
def redness(i):
  return hex(i).rstrip("L").lstrip("0x")

@app.route('/')
@app.route('/<int:task>')
@app.route('/<nickname>/<int:task>')
def index(task=1, nickname=""):
  taskfile = './questions/{}'.format(task)
  with open(taskfile, 'r') as myfile:
    code = myfile.read()

  sorted_scores = sorted(ANSWERED_GOOD.items(),
                         key = lambda kv: len(kv[1]),
                         reverse = True
  )
  return render_template('index.html',
                         code = code,
                         task = task,
                         scores = sorted_scores,
                         nickname = nickname,
                         redness = redness
  )

@app.route('/answer/<int:task>')
def answer(task=1):
  nickname = request.args.get('nickname')
  userans = request.args.get('answer')

  ansfile = './answers/{}'.format(task)
  with open(ansfile, 'r') as myfile:
    trueans = myfile.read().strip()

  if trueans == userans and nickname != "":
    good_answer (task, nickname)
    # next task
    task = task + 1
    if task == 16:
      task = 1

  return redirect(url_for('index',
                          task=task,
                          nickname = nickname
  ))



if __name__ == "__main__":
  logger = logging.getLogger('werkzeug')
  handler = logging.FileHandler('./logs/access.log')
  logger.addHandler(handler)
  app.run(host='0.0.0.0', debug=True, threaded=True)
